#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
using namespace std;

typedef unsigned int u;

int countDigits(int num) {
    return floor(log2(abs(num))) + 1;
}

u invertBits(u num, int k) {
    return (~num) & ((1 << k) - 1);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    
    int t;
    cin >> t;
    
    while (t--) {
        int n;
        cin >> n;
        
        vector<u> p(n + 1);
        vector<u> q(n + 1);
        int x = 0;
        
        for (int i = 0; i <= n; i++) 
            cin >> p[i];
        
        int k = countDigits(n + 1);
        
        for (int i = 0; i <= n; i++) {
            u tmp = invertBits(p[i], k);
            q[i] = (tmp > n) ? (tmp - n - 1) : tmp;
            x += p[i] ^ q[i];
        }
        
        cout << x << '\n';
        
        for (int i = 0; i <= n; i++)
            cout << q[i] << " ";
        
        if (t != 0)
            cout << '\n';
    }
    
    return 0;
}